#include <unordered_map>
#include <algorithm>
#include <iostream>
#include <vector>
#include <cmath>
#include <stack>

using namespace std;

int Dig(int n) {
    int d = 0;
    while (n) {
        n >>= 1;
        d++;
    }
    return d;
}

class SegTree {
public:
    vector<vector<int>> values;
    stack<int> ded;
    int d = 0;
    int capacity;
    int size = 0;
    SegTree(int n)
    : values(Dig(n)) {
        int l = 1;
        for (auto& h : values) {
            h = vector<int>(l);
            l *= 2;
            d++;
        }
        capacity = l / 2;
        for (auto& v : values[d - 1]) {
            v = 0;
        }
        Build();
    }
    int Insert(int v) {
            values[d - 1][size++] = v;
            Update(size - 1);
            return size - 1;

    }
    void Build() {
        int length = capacity / 2;
        for (int i = d - 2; i >= 0; i--) {
            for (int e = 0; e < length; e++) {
                values[i][e] = __gcd(values[i + 1][2 * e], values[i + 1][2 * e + 1]);
            }
            length /= 2;
        }
    }
    void Update(int ix) {
        for (int i = d - 2; i >= 0; i--) {
            values[i][ix / 2] = __gcd(values[i][2 * (ix / 2)], values[i][2 * (ix / 2) + 1]);
        }
    }
    int Top() {
        return values[0][0];
    }
};

bool IsPeriod(vector<int>& v, int p) {
    int s = v.size();
    for (int i = 0; i < s / p; i++) {
        for (int j = i; j < s - (s / p); j += s / p) {
            if (v[j] != v[j + (s / p)]) {
                return false;
            }
        }
    }
    return true;
}

int main() {
    int n;
    int q;
    cin >> n >> q;
    SegTree tree(400000);
    vector<int> circle(n);
    vector<int> borders(n);
    unordered_map<int, int> copies;
    unordered_map<int, int> segTreeInd;
    for (auto& a : circle) {
        cin >> a;
    }
    for (int i = 0; i < n; i++) {
        borders[i] = circle[i] ^ circle[(i + 1) % n];
    }
    for (auto& v : borders) {
        if (copies.find(v) != copies.end()) {
            copies[v]++;
            tree.values[tree.d - 1][segTreeInd[v]]++;
            tree.Update(segTreeInd[v]);
            continue;
        }
        copies.insert(make_pair(v, 1));
        if (segTreeInd.find(v) == segTreeInd.end()) {
            int sti = tree.Insert(1);
            segTreeInd.insert(make_pair(v, sti));
            tree.Update(sti);
        }
    }
    vector<int> periods(q + 1);
    if (IsPeriod(borders, tree.Top())) {
        periods[0] = tree.Top();
    }
    else {
        periods[0] = n;
    }
    for (int u = 0; u < q; u++) {
        int i;
        int v;
        cin >> i >> v;
        --i;
        circle[i] = v;
        tree.values[tree.d - 1][segTreeInd[borders[i]]]--;
        tree.Update(segTreeInd[borders[i]]);
        tree.values[tree.d - 1][segTreeInd[borders[i - 1]]]--;
        tree.Update(segTreeInd[borders[i - 1]]);
        copies[borders[i]]--;
        copies[borders[i - 1]]--;
        borders[i - 1] = circle[i - 1] ^ circle[i];
        borders[i] = circle[i] ^ circle[i + 1];

        if (copies.find(borders[i - 1]) == copies.end()) {
            copies.insert(make_pair(borders[i - 1], 1));
            if (segTreeInd.find(borders[i - 1]) == segTreeInd.end()) {
                int sti = tree.Insert(1);
                segTreeInd.insert(make_pair(borders[i - 1], sti));
                tree.Update(sti);
            }
        }
        else {
            tree.values[tree.d - 1][segTreeInd[borders[i - 1]]]++;
            tree.Update(segTreeInd[borders[i - 1]]);
        }
        if (copies.find(borders[i]) == copies.end()) {
            copies.insert(make_pair(borders[i], 1));
            if (segTreeInd.find(borders[i - 1]) == segTreeInd.end()) {
                int sti = tree.Insert(1);
                segTreeInd.insert(make_pair(borders[i], sti));
                tree.Update(sti);
            }
        }
        else {
            tree.values[tree.d - 1][segTreeInd[borders[i]]]++;
            tree.Update(segTreeInd[borders[i]]);
        }

        if (IsPeriod(borders, tree.Top())) {
            periods[1 + i] = tree.Top();
        }
        else {
            periods[1 + i] = n;
        }
    }
    for (auto& p : periods) {
        cout << p << endl;
    }
    return 0;
}